/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.crafting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.crafting.model.CraftingRecipe;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.entities.model.physical.item.QuantifiedItemType;
import technology.rocketjump.undermount.jobs.CraftingTypeDictionary;
import technology.rocketjump.undermount.jobs.model.CraftingType;

@Singleton
public class CraftingRecipeDictionary {
    private final Map<CraftingType, List<CraftingRecipe>> byCraftingType = new HashMap<CraftingType, List<CraftingRecipe>>();
    private final Map<String, CraftingRecipe> byName = new HashMap<String, CraftingRecipe>();
    private final CraftingTypeDictionary craftingTypeDictionary;
    private final ItemTypeDictionary itemTypeDictionary;

    @Inject
    public CraftingRecipeDictionary(CraftingTypeDictionary craftingTypeDictionary, ItemTypeDictionary itemTypeDictionary) throws IOException {
        this.craftingTypeDictionary = craftingTypeDictionary;
        this.itemTypeDictionary = itemTypeDictionary;
        for (CraftingType craftingType : craftingTypeDictionary.getAll()) {
            this.byCraftingType.put(craftingType, new ArrayList());
        }
        FileHandle craftingRecipesJsonFile = Gdx.files.internal("assets/definitions/crafting-recipes.json");
        ObjectMapper objectMapper = new ObjectMapper();
        List craftingRecipes = (List)objectMapper.readValue(craftingRecipesJsonFile.readString(), objectMapper.getTypeFactory().constructParametrizedType(ArrayList.class, List.class, CraftingRecipe.class));
        for (CraftingRecipe craftingRecipe : craftingRecipes) {
            this.initCraftingRecipe(craftingRecipe);
            this.byCraftingType.get(craftingRecipe.getCraftingType()).add(craftingRecipe);
            this.byName.put(craftingRecipe.getRecipeName(), craftingRecipe);
        }
    }

    private void initCraftingRecipe(CraftingRecipe craftingRecipe) {
        ItemType itemType;
        CraftingType relatedCraftingType = this.craftingTypeDictionary.getByName(craftingRecipe.getCraftingTypeName());
        craftingRecipe.setCraftingType(relatedCraftingType);
        if (craftingRecipe.getItemTypeRequiredName() != null) {
            ItemType itemType2 = this.itemTypeDictionary.getByName(craftingRecipe.getItemTypeRequiredName());
            if (itemType2 == null) {
                System.err.println("Could not find item type with name " + craftingRecipe.getItemTypeRequiredName() + " required for recipe " + craftingRecipe.getRecipeName());
            } else {
                craftingRecipe.setItemTypeRequired(itemType2);
            }
        }
        for (QuantifiedItemType quantifiedItemType : craftingRecipe.getInput()) {
            itemType = this.itemTypeDictionary.getByName(quantifiedItemType.getItemTypeName());
            if (itemType == null) {
                System.err.println("Could not find item type with name " + craftingRecipe.getItemTypeRequiredName() + " required for recipe " + craftingRecipe.getRecipeName());
                continue;
            }
            quantifiedItemType.setItemType(itemType);
        }
        for (QuantifiedItemType quantifiedItemType : craftingRecipe.getOutput()) {
            itemType = this.itemTypeDictionary.getByName(quantifiedItemType.getItemTypeName());
            if (itemType == null) {
                System.err.println("Could not find item type with name " + craftingRecipe.getItemTypeRequiredName() + " required for recipe " + craftingRecipe.getRecipeName());
                continue;
            }
            quantifiedItemType.setItemType(itemType);
        }
    }

    public List<CraftingRecipe> getByCraftingType(CraftingType craftingType) {
        return this.byCraftingType.get(craftingType);
    }
}

